# Mitch's Open File Directory

Welcome to **Mitch's Open File Directory** – a simple and open space where I host various files that I need for build servers or just for personal memes. This site is designed to be functional, straightforward, and accessible to anyone who might need to grab a file or two.

## 📁 Directory Structure

This site is structured as an open file directory, meaning you can browse through the folders and files directly. It’s a place for:

- **Build Server Files**: Hosting essential files for automated build processes, including binaries, scripts, and other resources.
- **Personal Memes**: A collection of personal memes, images, and other fun content that I like to share or keep handy.
- **Miscellaneous**: Anything else that doesn’t fit neatly into a category but still needs a home.

## 🔧 Technical Details

- **Server**: Nginx running on Ubuntu
- **PHP**: Powered by PHP with Directory Lister for an intuitive browsing experience
- **Hosting**: This site is hosted on a personal server, making it easily accessible for my needs.

## 🛠️ How It Works

This site uses **Directory Lister**, a PHP-based directory listing script, to display the contents of directories openly. It’s configured to show a PHP-based index at the root, with normal directory browsing enabled for subdirectories.

## 🔐 Privacy & Security

While this is an open directory, I’ve made sure to secure sensitive areas and files. If you find something that shouldn't be public, please let me know.

## 📬 Contact

If you have any questions, suggestions, or just want to share a meme, feel free to reach out to me at: [the@mitch.gg](mailto:the@mitch.gg)

## 🚀 Future Plans

- **Improved File Categorization**: I might add tags or categories to better organize files.
- **Meme Archive**: Creating a dedicated section just for memes, because why not?
- **Automated Cleanup**: Implementing scripts to automatically manage and clean up old or unused files.

---

Thanks for stopping by and happy browsing! 🎉
